# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

SUPPLEMENTARY_UNITS_TO_COMMODITY_CODES = {
    'p/st': [
        '01012100', '01012910', '01012990', '01013000', '01019000', '01022110', '01022130', '01022190', '01022905', '01022910', '01022921', '01022929', '01022941', '01022949', '01022951', '01022959',
        '01022961', '01022969', '01022991', '01022999', '01023100', '01023910', '01023990', '01029020', '01029091', '01029099', '01031000', '01039110', '01039190', '01039211', '01039219', '01039290',
        '01041010', '01041030', '01041080', '01042010', '01042090', '01051111', '01051119', '01051191', '01051199', '01051200', '01051300', '01051400', '01051500', '01059400', '01059910', '01059920',
        '01059930', '01059950', '01061100', '01061200', '01061300', '01061410', '01062000', '01063100', '01063200', '01063300', '01063910', '04071100', '04071911', '04071919', '04071990', '04072990',
        '04079090', '05111000', '06011010', '06011020', '06011030', '06011040', '06011090', '06022020', '06022030', '06022080', '06023000', '06024000', '06029041', '06029045', '06029046', '06029047',
        '06029048', '06029070', '06029091', '06029099', '06031100', '06031200', '06031300', '06031400', '06031500', '06031910', '06031920', '06031970', '06042020', '30024110', '37012000', '37025300',
        '37025400', '37029690', '39233010', '39233090', '39252000', '39269060', '40111000', '40112010', '40112090', '40113000', '40114000', '40115000', '40117000', '40118000', '40119000', '40121100',
        '40121200', '40121300', '40121900', '40122000', '40131000', '40132000', '40139000', '41012010', '41012030', '41012050', '41012080', '41015010', '41015030', '41015050', '41015090', '41021010',
        '41021090', '41022100', '41022900', '41032000', '41033000', '41041110', '41041151', '41041159', '41041190', '41041910', '41041951', '41041959', '41041990', '41044111', '41044119', '41044151',
        '41044159', '41044190', '41044911', '41044919', '41044951', '41044959', '41044990', '41051000', '41053010', '41053090', '41062100', '41062210', '41062290', '41063100', '41063200', '41064010',
        '41064090', '41069200', '41141010', '41141090', '42021110', '42021211', '42021291', '42022100', '42022210', '42022290', '42022900', '43011000', '43013000', '43016000', '43021100', '43021915',
        '43021935', '43021941', '43021949', '43021975', '43021980', '43023025', '43023051', '43023055', '44152020', '44181100', '44181950', '44181990', '44182110', '44182190', '44182950', '44182980',
        '44211000', '44212000', '61012010', '61012090', '61013010', '61013090', '61019020', '61019080', '61021010', '61021090', '61022010', '61022090', '61023010', '61023090', '61029010', '61029090',
        '61031010', '61031090', '61032200', '61032300', '61032900', '61033100', '61033200', '61033300', '61033900', '61034100', '61034200', '61034300', '61034900', '61041300', '61041920', '61041990',
        '61042200', '61042300', '61042910', '61042990', '61043100', '61043200', '61043300', '61043900', '61044100', '61044200', '61044300', '61044400', '61044900', '61045100', '61045200', '61045300',
        '61045900', '61046100', '61046200', '61046300', '61046900', '61051000', '61052010', '61052090', '61059010', '61059090', '61061000', '61062000', '61069010', '61069030', '61069050', '61069090',
        '61071100', '61071200', '61071900', '61072100', '61072200', '61072900', '61079100', '61079900', '61081100', '61081900', '61082100', '61082200', '61082900', '61083100', '61083200', '61083900',
        '61089100', '61089200', '61089900', '61091000', '61099020', '61099090', '61101110', '61101130', '61101190', '61101210', '61101290', '61101910', '61101990', '61102010', '61102091', '61102099',
        '61103010', '61103091', '61103099', '61109010', '61109090', '61121100', '61121200', '61121900', '61123110', '61123190', '61123910', '61123990', '61124110', '61124190', '61124910', '61124990',
        '61152100', '61152200', '61152900', '62012000', '62013010', '62013090', '62014010', '62014090', '62019000', '62022000', '62023010', '62023090', '62024010', '62024090', '62029000', '62031100',
        '62031200', '62031910', '62031930', '62031990', '62032210', '62032280', '62032310', '62032380', '62032911', '62032918', '62032930', '62032990', '62033100', '62033210', '62033290', '62033310',
        '62033390', '62033911', '62033919', '62033990', '62034110', '62034130', '62034190', '62034211', '62034231', '62034233', '62034235', '62034251', '62034259', '62034290', '62034311', '62034319',
        '62034331', '62034339', '62034390', '62034911', '62034919', '62034931', '62034939', '62034950', '62034990', '62041100', '62041200', '62041300', '62041910', '62041990', '62042100', '62042210',
        '62042280', '62042310', '62042380', '62042911', '62042918', '62042990', '62043100', '62043210', '62043290', '62043310', '62043390', '62043911', '62043919', '62043990', '62044100', '62044200',
        '62044300', '62044400', '62044910', '62044990', '62045100', '62045200', '62045300', '62045910', '62045990', '62046110', '62046185', '62046211', '62046231', '62046233', '62046239', '62046251',
        '62046259', '62046290', '62046311', '62046318', '62046331', '62046339', '62046390', '62046911', '62046918', '62046931', '62046939', '62046950', '62046990', '62052000', '62053000', '62059010',
        '62059080', '62061000', '62062000', '62063000', '62064000', '62069010', '62069090', '62071100', '62071900', '62072100', '62072200', '62072900', '62081100', '62081900', '62082100', '62082200',
        '62082900', '62102000', '62103000', '62111100', '62111200', '62112000', '62113231', '62113241', '62113242', '62113331', '62113341', '62113342', '62114231', '62114241', '62114242', '62114331',
        '62114341', '62114342', '62121010', '62121090', '62122000', '62123000', '62132000', '62139000', '62141000', '62142000', '62143000', '62144000', '62149000', '62151000', '62152000', '62159000',
        '63011000', '63012010', '63012090', '63013010', '63013090', '63014010', '63014090', '63019010', '63019090', '63041100', '63041910', '63041930', '63041990', '63042000', '63064000', '63079093',
        '63079095', '65010000', '65020000', '65040000', '65050010', '65050030', '65061010', '65061080', '65069100', '65069910', '65069990', '66011000', '66019100', '66019920', '66019990', '69041000',
        '69051000', '70091000', '70101000', '70109010', '70109021', '70109031', '70109041', '70109043', '70109045', '70109047', '70109051', '70109053', '70109055', '70109057', '70109061', '70109067',
        '70109071', '70109079', '70109091', '70109099', '70131000', '70132210', '70132290', '70132810', '70132890', '70133311', '70133319', '70133391', '70133399', '70133710', '70133751', '70133759',
        '70133791', '70133799', '70134110', '70134190', '70134200', '70134910', '70134991', '70134999', '70139110', '70139190', '70139900', '73083000', '73110011', '73110013', '73110019', '73110030',
        '73211110', '73211190', '73211200', '73211900', '73218100', '73218200', '73218900', '73242100', '73242900', '76101000', '76129020', '82011000', '82015000', '82121010', '82121090', '84071000',
        '84072110', '84072191', '84072199', '84072900', '84073100', '84073210', '84073290', '84073320', '84073380', '84073410', '84073430', '84073491', '84073499', '84079010', '84079050', '84079080',
        '84079090', '84081011', '84081019', '84081023', '84081027', '84081031', '84081039', '84081041', '84081049', '84081051', '84081059', '84081061', '84081069', '84081071', '84081079', '84081081',
        '84081089', '84081091', '84081099', '84082010', '84082031', '84082035', '84082037', '84082051', '84082055', '84082057', '84082099', '84089021', '84089027', '84089041', '84089043', '84089045',
        '84089047', '84089061', '84089065', '84089067', '84089081', '84089085', '84089089', '84111100', '84111210', '84111230', '84111280', '84112100', '84112220', '84112280', '84118100', '84118220',
        '84118260', '84118280', '84121000', '84131100', '84131900', '84132000', '84133020', '84133080', '84134000', '84135040', '84135061', '84135069', '84135080', '84136031', '84136039', '84136061',
        '84136069', '84136070', '84136080', '84137021', '84137029', '84137030', '84137035', '84137045', '84137051', '84137059', '84137065', '84137075', '84137081', '84137089', '84138100', '84138200',
        '84141015', '84141025', '84141081', '84141089', '84142020', '84142080', '84143020', '84143081', '84143089', '84144010', '84144090', '84145100', '84145915', '84145925', '84145935', '84145995',
        '84146000', '84147000', '84148011', '84148019', '84148022', '84148028', '84148051', '84148059', '84148073', '84148075', '84148078', '84148080', '84161010', '84161090', '84162010', '84162020',
        '84178030', '84178050', '84181020', '84181080', '84182110', '84182151', '84182159', '84182191', '84182199', '84182900', '84183020', '84183080', '84184020', '84184080', '84185011', '84185019',
        '84185090', '84211200', '84221100', '84221900', '84231010', '84231090', '84232010', '84232090', '84233010', '84233090', '84238121', '84238123', '84238125', '84238129', '84238180', '84238220',
        '84238281', '84238289', '84238920', '84238980', '84243001', '84243008', '84244100', '84244910', '84244990', '84251100', '84251900', '84253100', '84253900', '84254100', '84254200', '84254900',
        '84269110', '84271010', '84271090', '84272011', '84272019', '84272090', '84279000', '84291100', '84291900', '84292000', '84293000', '84294010', '84294030', '84294090', '84295110', '84295191',
        '84295199', '84295210', '84295290', '84295900', '84301000', '84302000', '84306100', '84321000', '84322100', '84322910', '84322930', '84322950', '84322990', '84323100', '84323911', '84323919',
        '84323990', '84324100', '84324200', '84331110', '84331151', '84331159', '84331190', '84331910', '84331951', '84331959', '84331970', '84331990', '84332010', '84332050', '84332090', '84333000',
        '84334000', '84335100', '84335200', '84335310', '84335330', '84335390', '84335911', '84335919', '84335985', '84368010', '84371000', '84423000', '84431100', '84431200', '84431310', '84431332',
        '84431334', '84431338', '84431390', '84431400', '84431500', '84431600', '84431700', '84431920', '84431940', '84431970', '84433100', '84433210', '84433280', '84433900', '84440010', '84440090',
        '84451100', '84451200', '84451300', '84451900', '84452000', '84453000', '84454000', '84459000', '84461000', '84462100', '84462900', '84463000', '84471100', '84471200', '84472020', '84472080',
        '84479000', '84501111', '84501119', '84501190', '84501200', '84501900', '84502000', '84513000', '84521011', '84521019', '84521090', '84522100', '84522900', '84561110', '84561190', '84561210',
        '84561290', '84562000', '84563011', '84563019', '84563090', '84564000', '84565000', '84569000', '84571010', '84571090', '84572000', '84573010', '84573090', '84581120', '84581141', '84581149',
        '84581180', '84581900', '84589120', '84589180', '84589900', '84591000', '84592100', '84592900', '84593100', '84593900', '84594100', '84594900', '84595100', '84595900', '84596110', '84596190',
        '84596910', '84596990', '84597000', '84601200', '84601900', '84602200', '84602300', '84602400', '84602910', '84602990', '84603100', '84603900', '84604010', '84604090', '84609000', '84612000',
        '84613010', '84613090', '84614011', '84614019', '84614031', '84614039', '84614071', '84614079', '84614090', '84615011', '84615019', '84615090', '84619000', '84621110', '84621190', '84621910',
        '84621990', '84622210', '84622290', '84622300', '84622400', '84622500', '84622600', '84622910', '84622990', '84623210', '84623290', '84623300', '84623900', '84624200', '84624900', '84625100',
        '84625900', '84626110', '84626190', '84626210', '84626290', '84626310', '84626390', '84626910', '84626990', '84629010', '84629090', '84631010', '84631090', '84632000', '84633000', '84639000',
        '84641000', '84642011', '84651010', '84651090', '84652000', '84659110', '84659120', '84659190', '84659200', '84659300', '84659400', '84659500', '84659600', '84659900', '84672110', '84672191',
        '84672199', '84672210', '84672230', '84672290', '84672920', '84672951', '84672953', '84672959', '84672970', '84672980', '84672985', '84678100', '84701000', '84702100', '84702900', '84703000',
        '84705000', '84709000', '84713000', '84714100', '84714900', '84715000', '84716060', '84716070', '84717020', '84717030', '84717050', '84717070', '84717080', '84717098', '84718000', '84719000',
        '84721000', '84723000', '84729010', '84762100', '84762900', '84768100', '84768910', '84768990', '84771000', '84772000', '84773000', '84774000', '84775100', '84775910', '84775980', '84778011',
        '84778019', '84778091', '84778093', '84778095', '84794000', '84851000', '84852000', '84853090', '84858000', '84871010', '84871090', '85011010', '85011091', '85011093', '85011099', '85012000',
        '85013100', '85013200', '85013300', '85013400', '85014020', '85014080', '85015100', '85015220', '85015230', '85015290', '85015350', '85015381', '85015394', '85015399', '85016120', '85016180',
        '85016200', '85016300', '85016400', '85017100', '85017200', '85018000', '85021120', '85021180', '85021200', '85021320', '85021340', '85021380', '85022020', '85022040', '85022060', '85022080',
        '85023100', '85023920', '85023980', '85024000', '85041020', '85041080', '85042100', '85042210', '85042290', '85042300', '85043121', '85043129', '85043180', '85043200', '85043300', '85043400',
        '85044030', '85044055', '85061011', '85061018', '85061091', '85061098', '85063000', '85064000', '85065010', '85065030', '85065090', '85066000', '85068005', '85068080', '85071020', '85071080',
        '85073020', '85075000', '85076000', '85078000', '85081100', '85081900', '85086000', '85094000', '85101000', '85102000', '85103000', '85123010', '85141100', '85141910', '85141980', '85142010',
        '85142080', '85143110', '85143190', '85143210', '85143290', '85143910', '85143990', '85144000', '85158010', '85158090', '85161011', '85161080', '85162100', '85162910', '85162950', '85162991',
        '85162999', '85163100', '85163300', '85164000', '85165000', '85166010', '85166050', '85166070', '85166080', '85166090', '85167100', '85167200', '85167920', '85167970', '85171100', '85171300',
        '85171400', '85176100', '85176910', '85176930', '85182100', '85182200', '85182900', '85184000', '85185000', '85192010', '85192091', '85192099', '85193000', '85198100', '85198900', '85211020',
        '85211095', '85219000', '85232100', '85232915', '85232919', '85234110', '85234130', '85234910', '85234920', '85234990', '85235110', '85235190', '85235200', '85235910', '85235990', '85241100',
        '85241200', '85241900', '85249100', '85249200', '85249900', '85255000', '85256000', '85258100', '85258200', '85258300', '85258900', '85269120', '85271200', '85271300', '85271900', '85272120',
        '85272152', '85272159', '85272170', '85272192', '85272198', '85272900', '85279100', '85279200', '85279900', '85284200', '85284900', '85285210', '85285291', '85285299', '85285900', '85286200',
        '85286920', '85286980', '85287111', '85287115', '85287119', '85287191', '85287199', '85287210', '85287220', '85287230', '85287240', '85287260', '85287280', '85287300', '85311030', '85311095',
        '85391000', '85392130', '85392192', '85392198', '85392210', '85392290', '85392930', '85392992', '85392998', '85393110', '85393190', '85393220', '85393290', '85393920', '85393980', '85394100',
        '85394900', '85395100', '85395200', '85401100', '85401200', '85402010', '85402080', '85404000', '85406000', '85407100', '85407900', '85408100', '85408900', '85423231', '85423239', '85423245',
        '85423255', '85423261', '85423269', '85423275', '85437050', '85491210', '85491310', '85491410', '85491910', '86011000', '86012000', '86031000', '86039000', '86040000', '86050000', '86061000',
        '86063000', '86069110', '86069180', '86069200', '86069900', '86090010', '86090090', '87011000', '87012110', '87012190', '87012210', '87012290', '87012310', '87012390', '87012410', '87012490',
        '87012900', '87013000', '87019110', '87019190', '87019210', '87019290', '87019310', '87019390', '87019410', '87019490', '87019510', '87019590', '87021011', '87021019', '87021091', '87021099',
        '87022010', '87022090', '87023010', '87023090', '87024000', '87029011', '87029019', '87029031', '87029039', '87029090', '87031011', '87031018', '87032110', '87032190', '87032210', '87032290',
        '87032311', '87032319', '87032390', '87032410', '87032490', '87033110', '87033190', '87033211', '87033219', '87033290', '87033311', '87033319', '87033390', '87034010', '87034090', '87035000',
        '87036010', '87036090', '87037000', '87038010', '87038090', '87039000', '87041010', '87041090', '87042110', '87042131', '87042139', '87042191', '87042199', '87042210', '87042291', '87042299',
        '87042310', '87042391', '87042399', '87043110', '87043131', '87043139', '87043191', '87043199', '87043210', '87043291', '87043299', '87044110', '87044131', '87044139', '87044191', '87044199',
        '87044210', '87044291', '87044299', '87044310', '87044391', '87044399', '87045110', '87045131', '87045139', '87045191', '87045199', '87045210', '87045291', '87045299', '87046000', '87049000',
        '87051000', '87052000', '87053000', '87054000', '87059030', '87059080', '87060011', '87060019', '87060091', '87060099', '87071010', '87071090', '87079010', '87079090', '87082110', '87082190',
        '87089510', '87091110', '87091190', '87091910', '87091990', '87111000', '87112010', '87112092', '87112098', '87113010', '87113090', '87114000', '87115000', '87116010', '87116090', '87119000',
        '87120030', '87120070', '87131000', '87139000', '87149110', '87149130', '87149210', '87149910', '87149930', '87150010', '87161092', '87161098', '87162000', '87163100', '87163910', '87163930',
        '87163950', '87163980', '88010010', '88010090', '88021100', '88021200', '88022000', '88023000', '88024000', '88026011', '88026019', '88026090', '88061010', '88061090', '88062110', '88062190',
        '88062210', '88062290', '88062300', '88062400', '88062910', '88062920', '88069100', '88069200', '88069300', '88069400', '88069910', '88069920', '89011010', '89011090', '89012010', '89013010',
        '89019010', '89020010', '89020090', '89031100', '89031200', '89031900', '89032100', '89032210', '89032290', '89032310', '89032390', '89033100', '89033210', '89033290', '89033310', '89033390',
        '89039310', '89039390', '89039910', '89039999', '89040010', '89040091', '89051010', '89051090', '89052000', '89059010', '89059090', '89061000', '89069010', '89069091', '89069099', '89071000',
        '89079000', '90013000', '90014020', '90014041', '90014049', '90014080', '90015020', '90015041', '90015049', '90015080', '90021100', '90021900', '90022000', '90031100', '90031900', '90041010',
        '90041091', '90041099', '90051000', '90063000', '90064000', '90065310', '90065380', '90065900', '90066100', '90066900', '90071000', '90072000', '90085000', '90111000', '90112010', '90112090',
        '90118000', '90142020', '90160010', '90171010', '90171090', '90172005', '90172039', '90172090', '90173000', '90192010', '90192020', '90200010', '90214000', '90215000', '90221200', '90221300',
        '90221400', '90221900', '90222100', '90222900', '90223000', '90251120', '90251180', '90251900', '90258020', '90261021', '90261029', '90261081', '90261089', '90262020', '90262040', '90262080',
        '90271010', '90271090', '90278100', '90281000', '90282000', '90283011', '90283019', '90283090', '90314910', '90321020', '90321080', '90322000', '91011100', '91011900', '91012100', '91012900',
        '91019100', '91019900', '91021100', '91021200', '91021900', '91022100', '91022900', '91029100', '91029900', '91031000', '91039000', '91040000', '91051100', '91051900', '91052100', '91052900',
        '91059100', '91059900', '91061000', '91069000', '91070000', '91081100', '91081200', '91081900', '91082000', '91089000', '91091000', '91099000', '91101110', '91101190', '91111000', '91112000',
        '91118000', '91122000', '92011010', '92011090', '92012000', '92021010', '92021090', '92029030', '92029080', '92051000', '92059010', '92059030', '92071010', '92071030', '92071050', '92079010',
        '93011000', '93012000', '93019000', '93020000', '93031000', '93032010', '93032095', '93033000', '93039000', '93040000', '94043000', '95043010', '95043020', '95061121', '95063100', '95063200',
        '96031000', '96032100', '96032930', '96033010', '96033090', '96034010', '96034090', '96039010', '96081010', '96081092', '96081099', '96082000', '96083000', '96084000', '96086000', '96131000',
        '96132000'],
    '1 000 p/st': ['04072100', '04072910', '04079010', '24021000', '24022010', '24022090', '82122000', '84523000', '93062100'],
    'kg/net eda': ['07115100', '20011000', '20031020', '20031030', '20057000'],
    'l alc. 100 %': [
        '21039030', '21069020', '22082012', '22082014', '22082016', '22082018', '22082019', '22082026', '22082028', '22082062', '22082066', '22082069', '22082086', '22082088', '22083011', '22083019',
        '22083030', '22083041', '22083049', '22083061', '22083069', '22083071', '22083079', '22083082', '22083088', '22084011', '22084031', '22084039', '22084051', '22084091', '22084099', '22085011',
        '22085019', '22085091', '22085099', '22086011', '22086019', '22086091', '22086099', '22087010', '22087090', '22089011', '22089019', '22089033', '22089038', '22089041', '22089045', '22089048',
        '22089054', '22089056', '22089069', '22089071', '22089075', '22089077', '22089078', '22089091', '22089099'],
    'l': [
        '22011011', '22011019', '22011090', '22021000', '22029100', '22029911', '22029915', '22029919', '22029991', '22029995', '22029999', '22030001', '22030009', '22030010', '22041011', '22041013',
        '22041015', '22041091', '22041093', '22041094', '22041096', '22041098', '22042106', '22042107', '22042108', '22042109', '22042111', '22042112', '22042113', '22042117', '22042118', '22042119',
        '22042122', '22042123', '22042124', '22042126', '22042127', '22042128', '22042131', '22042132', '22042134', '22042136', '22042137', '22042138', '22042142', '22042143', '22042144', '22042146',
        '22042147', '22042148', '22042161', '22042162', '22042166', '22042167', '22042168', '22042169', '22042171', '22042174', '22042176', '22042177', '22042178', '22042179', '22042180', '22042181',
        '22042182', '22042183', '22042184', '22042185', '22042186', '22042187', '22042188', '22042189', '22042190', '22042191', '22042193', '22042194', '22042195', '22042196', '22042197', '22042198',
        '22042210', '22042222', '22042223', '22042224', '22042226', '22042227', '22042228', '22042232', '22042233', '22042238', '22042278', '22042279', '22042280', '22042281', '22042282', '22042283',
        '22042284', '22042285', '22042286', '22042288', '22042290', '22042291', '22042293', '22042294', '22042295', '22042296', '22042297', '22042298', '22042910', '22042922', '22042923', '22042924',
        '22042926', '22042927', '22042928', '22042932', '22042938', '22042978', '22042979', '22042980', '22042981', '22042982', '22042983', '22042984', '22042985', '22042986', '22042988', '22042990',
        '22042991', '22042993', '22042994', '22042995', '22042996', '22042997', '22042998', '22043010', '22043092', '22043094', '22043096', '22043098', '22051010', '22051090', '22059010', '22059090',
        '22060010', '22060031', '22060039', '22060051', '22060059', '22060081', '22060089', '22071000', '22072000', '22090011', '22090019', '22090091', '22090099'],
    '1 000 m3': ['27050000'],
    'm3': [
        '27101241', '27101245', '27101249', '27101250', '28041000', '28042100', '28042910', '28042990', '28043000', '28044000', '44031100', '44031200', '44032110', '44032190', '44032200', '44032310',
        '44032390', '44032400', '44032510', '44032590', '44032600', '44034100', '44034200', '44034910', '44034935', '44034985', '44039100', '44039300', '44039400', '44039510', '44039590', '44039600',
        '44039700', '44039800', '44039900', '44061100', '44061200', '44069100', '44069200', '44071110', '44071120', '44071190', '44071210', '44071220', '44071290', '44071300', '44071400', '44071910',
        '44071920', '44071990', '44072110', '44072191', '44072199', '44072210', '44072291', '44072299', '44072310', '44072320', '44072390', '44072510', '44072530', '44072550', '44072590', '44072610',
        '44072630', '44072650', '44072690', '44072710', '44072791', '44072799', '44072810', '44072891', '44072899', '44072915', '44072920', '44072983', '44072985', '44072995', '44072996', '44072997',
        '44072998', '44079115', '44079139', '44079190', '44079200', '44079310', '44079391', '44079399', '44079410', '44079491', '44079499', '44079510', '44079591', '44079599', '44079610', '44079691',
        '44079699', '44079710', '44079791', '44079799', '44079927', '44079940', '44079990', '44081015', '44081091', '44081098', '44083111', '44083121', '44083125', '44083130', '44083915', '44083921',
        '44083930', '44083955', '44083970', '44083985', '44083995', '44089015', '44089035', '44089085', '44089095', '44101110', '44101130', '44101150', '44101190', '44101210', '44101290', '44101900',
        '44109000', '44111210', '44111292', '44111294', '44111310', '44111392', '44111394', '44111410', '44111492', '44111495', '44111497', '44119210', '44119290', '44119300', '44119410', '44119490',
        '44121000', '44123110', '44123190', '44123310', '44123320', '44123330', '44123390', '44123400', '44123900', '44124191', '44124199', '44124200', '44124900', '44125110', '44125190', '44125200',
        '44125900', '44129110', '44129191', '44129199', '44129210', '44129290', '44129910', '44129990', '44130000', '44209010'],
    'TJ': ['27111100', '27112100'],
    '1 000 kWh': ['27160000'],
    'kg P2O5': ['28091000', '28092000', '31031100', '31031900', '31039000'],
    'kg NaOH': ['28151200'],
    'kg KOH': ['28152000'],
    'g': [
        '28433000', '28439090', '29371100', '29371200', '29371900', '29372100', '29372200', '29372300', '29372900', '29375000', '29379000', '71011000', '71012100', '71012200', '71039100', '71039900',
        '71041000', '71042100', '71042900', '71049100', '71049900', '71051000', '71059000', '71061000', '71069100', '71069200', '71081100', '71081200', '71081310', '71081380', '71082000', '71101100',
        '71101910', '71101980', '71102100', '71102900', '71103100', '71103900', '71104100', '71104900', '71131100', '71131900', '71141100', '71141900', '71161000', '71162011', '71162080', '71181000',
        '71189000'],
    'kg U': ['28441010', '28441030', '28441050', '28441090'],
    'gi F / S': ['28442025', '28442035', '28442051', '28442059', '28442099', '28445000', '84013000'],
    'kg H2O2': ['28470000'],
    'kg met.am.': ['29211100'],
    'kg N': ['31021010', '31021090', '31022100', '31022900', '31023010', '31023090', '31024010', '31024090', '31025000', '31026000', '31028000', '31029000'],
    'kg K2O': ['31042010', '31042050', '31042090', '31043000', '31049000'],
    'm2': [
        '37011000', '37013000', '37021000', '37024100', '37024200', '37024300', '37024400', '39181010', '39181090', '39189000', '40082110', '41071111', '41071119', '41071190', '41071211', '41071219',
        '41071291', '41071299', '41071910', '41071990', '41079190', '41079210', '41079290', '41079910', '41079990', '41120000', '41131000', '41132000', '41133000', '41139000', '41142000', '44079131',
        '44092991', '44187310', '44187390', '44187400', '44187500', '44187900', '50071000', '50072011', '50072019', '50072021', '50072031', '50072039', '50072041', '50072051', '50072059', '50072061',
        '50072069', '50072071', '50079010', '50079030', '50079050', '50079090', '51111100', '51111900', '51112000', '51113010', '51113080', '51119010', '51119091', '51119098', '51121100', '51121900',
        '51122000', '51123010', '51123080', '51129010', '51129091', '51129098', '51130000', '52081110', '52081190', '52081216', '52081219', '52081296', '52081299', '52081300', '52081900', '52082110',
        '52082190', '52082216', '52082219', '52082296', '52082299', '52082300', '52082900', '52083100', '52083216', '52083219', '52083296', '52083299', '52083300', '52083900', '52084100', '52084200',
        '52084300', '52084900', '52085100', '52085200', '52085910', '52085990', '52091100', '52091200', '52091900', '52092100', '52092200', '52092900', '52093100', '52093200', '52093900', '52094100',
        '52094200', '52094300', '52094900', '52095100', '52095200', '52095900', '52101100', '52101900', '52102100', '52102900', '52103100', '52103200', '52103900', '52104100', '52104900', '52105100',
        '52105900', '52111100', '52111200', '52111900', '52112000', '52113100', '52113200', '52113900', '52114100', '52114200', '52114300', '52114910', '52114990', '52115100', '52115200', '52115900',
        '52121110', '52121190', '52121210', '52121290', '52121310', '52121390', '52121410', '52121490', '52121510', '52121590', '52122110', '52122190', '52122210', '52122290', '52122310', '52122390',
        '52122410', '52122490', '52122510', '52122590', '53091110', '53091190', '53091900', '53092100', '53092900', '53101010', '53101090', '53109000', '53110010', '53110090', '54071000', '54072011',
        '54072019', '54072090', '54073000', '54074100', '54074200', '54074300', '54074400', '54075100', '54075200', '54075300', '54075400', '54076110', '54076130', '54076150', '54076190', '54076910',
        '54076990', '54077100', '54077200', '54077300', '54077400', '54078100', '54078200', '54078300', '54078400', '54079100', '54079200', '54079300', '54079400', '54081000', '54082100', '54082210',
        '54082290', '54082300', '54082400', '54083100', '54083200', '54083300', '54083400', '55121100', '55121910', '55121990', '55122100', '55122910', '55122990', '55129100', '55129910', '55129990',
        '55131120', '55131190', '55131200', '55131300', '55131900', '55132100', '55132310', '55132390', '55132900', '55133100', '55133900', '55134100', '55134900', '55141100', '55141200', '55141910',
        '55141990', '55142100', '55142200', '55142300', '55142900', '55143010', '55143030', '55143050', '55143090', '55144100', '55144200', '55144300', '55144900', '55151110', '55151130', '55151190',
        '55151210', '55151230', '55151290', '55151311', '55151319', '55151391', '55151399', '55151910', '55151930', '55151990', '55152110', '55152130', '55152190', '55152211', '55152219', '55152291',
        '55152299', '55152900', '55159110', '55159130', '55159190', '55159920', '55159940', '55159980', '55161100', '55161200', '55161300', '55161400', '55162100', '55162200', '55162310', '55162390',
        '55162400', '55163100', '55163200', '55163300', '55163400', '55164100', '55164200', '55164300', '55164400', '55169100', '55169200', '55169300', '55169400', '57011010', '57011090', '57019010',
        '57019090', '57021000', '57022000', '57023110', '57023180', '57023200', '57023900', '57024110', '57024190', '57024200', '57024900', '57025010', '57025031', '57025039', '57025090', '57029100',
        '57029210', '57029290', '57029900', '57031000', '57032100', '57032910', '57032919', '57032991', '57032999', '57033100', '57033910', '57033919', '57033991', '57033999', '57039020', '57039080',
        '57041000', '57042000', '57049000', '57050030', '57050080', '58011000', '58012100', '58012200', '58012300', '58012600', '58012700', '58013100', '58013200', '58013300', '58013600', '58013700',
        '58019010', '58019090', '58021000', '58022000', '58023000', '58030010', '58030030', '58030090', '58110000', '59011000', '59019000', '59021010', '59021090', '59022010', '59022090', '59029010',
        '59029090', '59031010', '59031090', '59032010', '59032090', '59039010', '59039091', '59039099', '59041000', '59049000', '59070000', '59113111', '59113211', '59113219', '63031200', '63031900',
        '63039100', '63039210', '63039290', '63039910', '63039990', '68071000', '68091100', '68091900', '69072100', '69072200', '69072300', '69073000', '69074000', '70031210', '70031291', '70031299',
        '70031910', '70031990', '70032000', '70042010', '70042091', '70042099', '70049010', '70049080', '70051005', '70051025', '70051030', '70051080', '70052125', '70052130', '70052180', '70052925',
        '70052935', '70052980', '70053000', '70071910', '70071920', '70071980', '70072900', '70080020', '70080081', '70080089', '70169010', '76061130', '76061230', '76072091'],
    'm': ['37023191', '37023197', '37025500', '37029790', '37061020', '37061099', '37069052', '37069091', '37069099', '44091011', '44092910', '96071100', '96071900'],
    'pa': [
        '40151200', '40151900', '42032100', '42032910', '42032990', '61112010', '61113010', '61119011', '61151010', '61153011', '61153019', '61153090', '61159400', '61159500', '61159610', '61159691',
        '61159699', '61159900', '61161020', '61161080', '61169100', '61169200', '61169300', '61169900', '62160000', '64011000', '64019210', '64019290', '64019900', '64021210', '64021290', '64021900',
        '64022000', '64029110', '64029190', '64029905', '64029910', '64029931', '64029939', '64029950', '64029991', '64029993', '64029996', '64029998', '64031200', '64031900', '64032000', '64034000',
        '64035105', '64035111', '64035115', '64035119', '64035191', '64035195', '64035199', '64035905', '64035911', '64035931', '64035935', '64035939', '64035950', '64035991', '64035995', '64035999',
        '64039105', '64039111', '64039113', '64039116', '64039118', '64039191', '64039193', '64039196', '64039198', '64039905', '64039911', '64039931', '64039933', '64039936', '64039938', '64039950',
        '64039991', '64039993', '64039996', '64039998', '64041100', '64041910', '64041990', '64042010', '64042090', '64051000', '64052010', '64052091', '64052099', '64059010', '64059090', '64069030',
        '87149610', '95061110', '95061129', '95061180', '95067010', '95067030'],
    'kg 90 % sdt': [
        '47010010', '47010090', '47020000', '47031100', '47031900', '47032100', '47032900', '47041100', '47041900', '47042100', '47042900', '47050000', '47062000', '47063000', '47069100', '47069200',
        '47069300'],
    'c/k': ['71021000', '71022100', '71022900', '71023100', '71023900'],
    'ce/el': ['85072020', '85072080', '85073080'],
    'ct/l': ['89012090', '89013090', '89019090'],
    '100 p/st': ['90212110', '90212190']
}
