import re
from xml.sax.saxutils import escape

def _replace_characters_SEPA(string, size=None):
    """
    Replace non-latin characters according to the official SEPA mapping.
    See https://www.europeanpaymentscouncil.eu/document-library/guidance-documents/sepa-requirements-extended-character-set-unicode-subset-best
    """
    string_array = [character for character in string]
    for match in re.finditer('[^-A-Za-z0-9/?:().,\'&<>+ ]', string):
        match_index = match.start()
        string_array[match_index] = sepa_mapping.get(string_array[match_index], '')
    string = ''.join(string_array)

    if size:
        string = string[:size]
        i = 0
        while len(escape(string)) > size:
            i += 1
            string = string[:size - i]

    return string

sepa_mapping = {
    "\u0021": "\u002E", "\u0023": "\u002E", "\u0024": "\u002E", "\u0025": "\u002E", "\u002A": "\u002E", "\u003B": "\u002C", "\u003C": "\u002E", "\u003D": "\u002E",
    "\u003E": "\u002E", "\u0040": "\u002E", "\u005B": "\u0028", "\u005C": "\u002F", "\u005D": "\u0029", "\u005E": "\u002E", "\u005F": "\u002D", "\u0060": "\u0027",
    "\u007B": "\u0028", "\u007C": "\u002F", "\u007D": "\u0029", "\u007E": "\u002D", "\u007F": "\u002E", "\u0080": "\u002E", "\u0081": "\u002E", "\u0082": "\u002E",
    "\u0083": "\u002E", "\u0084": "\u002E", "\u0085": "\u002E", "\u0086": "\u002E", "\u0087": "\u002E", "\u0088": "\u002E", "\u0089": "\u002E", "\u008A": "\u002E",
    "\u008B": "\u002E", "\u008C": "\u002E", "\u008D": "\u002E", "\u008E": "\u002E", "\u008F": "\u002E", "\u0090": "\u002E", "\u0091": "\u002E", "\u0092": "\u002E",
    "\u0093": "\u002E", "\u0094": "\u002E", "\u0095": "\u002E", "\u0096": "\u002E", "\u0097": "\u002E", "\u0098": "\u002E", "\u0099": "\u002E", "\u009A": "\u002E",
    "\u009B": "\u002E", "\u009C": "\u002E", "\u009D": "\u002E", "\u009E": "\u002E", "\u009F": "\u002E", "\u00A0": "\u0020", "\u00A1": "\u002E", "\u00A2": "\u002E",
    "\u00A3": "\u002E", "\u00A4": "\u002E", "\u00A5": "\u002E", "\u00A6": "\u002E", "\u00A7": "\u002E", "\u045E": "\u002E", "\u045F": "\u002E", "\u20AC": "\u0045",
    "\u00A8": "\u002E", "\u00A9": "\u002E", "\u00AA": "\u002E", "\u00AB": "\u002E", "\u00AC": "\u002E", "\u00AD": "\u002E", "\u00AE": "\u002E", "\u00AF": "\u002E",
    "\u00B0": "\u002E", "\u00B1": "\u002E", "\u00B2": "\u002E", "\u00B3": "\u002E", "\u00B4": "\u002E", "\u00B5": "\u002E", "\u00B6": "\u002E", "\u00B7": "\u002E",
    "\u00B8": "\u002E", "\u00B9": "\u002E", "\u00BA": "\u002E", "\u00BB": "\u002E", "\u00BC": "\u002E", "\u00BD": "\u002E", "\u00BE": "\u002E", "\u00BF": "\u003F",
    "\u00C0": "\u0041", "\u00C1": "\u0041", "\u00C2": "\u0041", "\u00C3": "\u0041", "\u00C4": "\u0041", "\u00C5": "\u0041", "\u00C6": "\u0041", "\u00C7": "\u0043",
    "\u00C8": "\u0045", "\u00C9": "\u0045", "\u00CA": "\u0045", "\u00CB": "\u0045", "\u00CC": "\u0049", "\u00CD": "\u0049", "\u00CE": "\u0049", "\u00CF": "\u0049",
    "\u00D0": "\u002E", "\u00D1": "\u004E", "\u00D2": "\u004F", "\u00D3": "\u004F", "\u00D4": "\u004F", "\u00D5": "\u004F", "\u00D6": "\u004F", "\u00D7": "\u002E",
    "\u00D8": "\u004F", "\u00D9": "\u0055", "\u00DA": "\u0055", "\u00DB": "\u0055", "\u00DC": "\u0055", "\u00DD": "\u0059", "\u00DE": "\u0054\u0048", "\u00DF": "\u0073",
    "\u00E0": "\u0061", "\u00E1": "\u0061", "\u00E2": "\u0061", "\u00E3": "\u0061", "\u00E4": "\u0061", "\u00E5": "\u0061", "\u00E6": "\u0061", "\u00E7": "\u0063",
    "\u00E8": "\u0065", "\u00E9": "\u0065", "\u00EA": "\u0065", "\u00EB": "\u0065", "\u00EC": "\u0069", "\u00ED": "\u0069", "\u00EE": "\u0069", "\u00EF": "\u0069",
    "\u00F0": "\u002E", "\u00F1": "\u006E", "\u00F2": "\u006F", "\u00F3": "\u006F", "\u00F4": "\u006F", "\u00F5": "\u006F", "\u00F6": "\u006F", "\u00F7": "\u002E",
    "\u00F8": "\u006F", "\u00F9": "\u0075", "\u00FA": "\u0075", "\u00FB": "\u0075", "\u00FC": "\u0075", "\u00FD": "\u0079", "\u00FE": "\u0074", "\u00FF": "\u0079",
    "\u0100": "\u0041", "\u0101": "\u0061", "\u0102": "\u0041", "\u0103": "\u0061", "\u0104": "\u0041", "\u0105": "\u0061", "\u0106": "\u0043", "\u0107": "\u0063",
    "\u0108": "\u0043", "\u0109": "\u0063", "\u010A": "\u0043", "\u010B": "\u0063", "\u010C": "\u0043", "\u010D": "\u0063", "\u010E": "\u0044", "\u010F": "\u0064",
    "\u0110": "\u0044", "\u0111": "\u0064", "\u0112": "\u0045", "\u0113": "\u0065", "\u0114": "\u0045", "\u0115": "\u0065", "\u0116": "\u0045", "\u0117": "\u0065",
    "\u0118": "\u0045", "\u0119": "\u0065", "\u011A": "\u0045", "\u011B": "\u0065", "\u011C": "\u0047", "\u011D": "\u0067", "\u011E": "\u0047", "\u011F": "\u0067",
    "\u0120": "\u0047", "\u0121": "\u0067", "\u0122": "\u0047", "\u0123": "\u0067", "\u0124": "\u0048", "\u0125": "\u0069", "\u0126": "\u0048", "\u0127": "\u0069",
    "\u0128": "\u0049", "\u0129": "\u0069", "\u012A": "\u0049", "\u012B": "\u0069", "\u012C": "\u0049", "\u012D": "\u0069", "\u012E": "\u0049", "\u012F": "\u0069",
    "\u0130": "\u0049", "\u0131": "\u0069", "\u0132": "\u0049", "\u0133": "\u0069", "\u0134": "\u004A", "\u0135": "\u006A", "\u0136": "\u004B", "\u0137": "\u006B",
    "\u0138": "\u002E", "\u0139": "\u004C", "\u013A": "\u006C", "\u013B": "\u004C", "\u013C": "\u006C", "\u013D": "\u004C", "\u013E": "\u006C", "\u013F": "\u004C",
    "\u0140": "\u006C", "\u0141": "\u004C", "\u0142": "\u006C", "\u0143": "\u004E", "\u0144": "\u006E", "\u0145": "\u004E", "\u0146": "\u006E", "\u0147": "\u004E",
    "\u0148": "\u006E", "\u0149": "\u002E", "\u014A": "\u002E", "\u014B": "\u002E", "\u014C": "\u002E", "\u014D": "\u002E", "\u014E": "\u002E", "\u014F": "\u002E",
    "\u0150": "\u004F", "\u0151": "\u006F", "\u0152": "\u004F", "\u0153": "\u006F", "\u0154": "\u0052", "\u0155": "\u0072", "\u0156": "\u0052", "\u0157": "\u0072",
    "\u0158": "\u0052", "\u0159": "\u0072", "\u015A": "\u0053", "\u015B": "\u0073", "\u015C": "\u0053", "\u015D": "\u0073", "\u015E": "\u0053", "\u015F": "\u0073",
    "\u0160": "\u0053", "\u0161": "\u0073", "\u0162": "\u0054", "\u0163": "\u0074", "\u0164": "\u0054", "\u0165": "\u0074", "\u0166": "\u0054", "\u0167": "\u0074",
    "\u0168": "\u0055", "\u0169": "\u0075", "\u016A": "\u0055", "\u016B": "\u0075", "\u016C": "\u0055", "\u016D": "\u0075", "\u016E": "\u0055", "\u016F": "\u0075",
    "\u0170": "\u0055", "\u0171": "\u0075", "\u0172": "\u0055", "\u0173": "\u0075", "\u0174": "\u0057", "\u0175": "\u0077", "\u0176": "\u0059", "\u0177": "\u0079",
    "\u0178": "\u0059", "\u0179": "\u005A", "\u017A": "\u007A", "\u017B": "\u005A", "\u017C": "\u007A", "\u017D": "\u005A", "\u017E": "\u007A", "\u017F": "\u002E",
    "\u0180": "\u002E", "\u0181": "\u002E", "\u0182": "\u002E", "\u0183": "\u002E", "\u0184": "\u002E", "\u0185": "\u002E", "\u0186": "\u002E", "\u0187": "\u002E",
    "\u0188": "\u002E", "\u0189": "\u002E", "\u018A": "\u002E", "\u018B": "\u002E", "\u018C": "\u002E", "\u018D": "\u002E", "\u018E": "\u002E", "\u018F": "\u002E",
    "\u0190": "\u002E", "\u0191": "\u002E", "\u0192": "\u002E", "\u0193": "\u002E", "\u0194": "\u002E", "\u0195": "\u002E", "\u0196": "\u002E", "\u0197": "\u002E",
    "\u0198": "\u002E", "\u0199": "\u002E", "\u019A": "\u002E", "\u019B": "\u002E", "\u019C": "\u002E", "\u019D": "\u002E", "\u019E": "\u002E", "\u019F": "\u002E",
    "\u01A0": "\u002E", "\u01A1": "\u002E", "\u01A2": "\u002E", "\u01A3": "\u002E", "\u01A4": "\u002E", "\u01A5": "\u002E", "\u01A6": "\u002E", "\u01A7": "\u002E",
    "\u01A8": "\u002E", "\u01A9": "\u002E", "\u01AA": "\u002E", "\u01AB": "\u002E", "\u01AC": "\u002E", "\u01AD": "\u002E", "\u01AE": "\u002E", "\u01AF": "\u002E",
    "\u01B0": "\u002E", "\u01B1": "\u002E", "\u01B2": "\u002E", "\u01B3": "\u002E", "\u01B4": "\u002E", "\u01B5": "\u002E", "\u01B6": "\u002E", "\u01B7": "\u002E",
    "\u01B8": "\u002E", "\u01B9": "\u002E", "\u01BA": "\u002E", "\u01BB": "\u002E", "\u01BC": "\u002E", "\u01BD": "\u002E", "\u01BE": "\u002E", "\u01BF": "\u002E",
    "\u01C0": "\u002E", "\u01C1": "\u002E", "\u01C2": "\u002E", "\u01C3": "\u002E", "\u01C4": "\u002E", "\u01C5": "\u002E", "\u01C6": "\u002E", "\u01C7": "\u002E",
    "\u01C8": "\u002E", "\u01C9": "\u002E", "\u01CA": "\u002E", "\u01CB": "\u002E", "\u01CC": "\u002E", "\u01CD": "\u002E", "\u01CE": "\u002E", "\u01CF": "\u002E",
    "\u01D0": "\u002E", "\u01D1": "\u002E", "\u01D2": "\u002E", "\u01D3": "\u002E", "\u01D4": "\u002E", "\u01D5": "\u002E", "\u01D6": "\u002E", "\u01D7": "\u002E",
    "\u01D8": "\u002E", "\u01D9": "\u002E", "\u01DA": "\u002E", "\u01DB": "\u002E", "\u01DC": "\u002E", "\u01DD": "\u002E", "\u01DE": "\u002E", "\u01DF": "\u002E",
    "\u01E0": "\u002E", "\u01E1": "\u002E", "\u01E2": "\u002E", "\u01E3": "\u002E", "\u01E4": "\u002E", "\u01E5": "\u002E", "\u01E6": "\u002E", "\u01E7": "\u002E",
    "\u01E8": "\u002E", "\u01E9": "\u002E", "\u01EA": "\u002E", "\u01EB": "\u002E", "\u01EC": "\u002E", "\u01ED": "\u002E", "\u01EE": "\u002E", "\u01EF": "\u002E",
    "\u01F0": "\u002E", "\u01F1": "\u002E", "\u01F2": "\u002E", "\u01F3": "\u002E", "\u01F4": "\u002E", "\u01F5": "\u002E", "\u01F6": "\u002E", "\u01F7": "\u002E",
    "\u01F8": "\u002E", "\u01F9": "\u002E", "\u01FA": "\u002E", "\u01FB": "\u002E", "\u01FC": "\u002E", "\u01FD": "\u002E", "\u01FE": "\u002E", "\u01FF": "\u002E",
    "\u0200": "\u002E", "\u0201": "\u002E", "\u0202": "\u002E", "\u0203": "\u002E", "\u0204": "\u002E", "\u0205": "\u002E", "\u0206": "\u002E", "\u0207": "\u002E",
    "\u0208": "\u002E", "\u0209": "\u002E", "\u020A": "\u002E", "\u020B": "\u002E", "\u020C": "\u002E", "\u020D": "\u002E", "\u020E": "\u002E", "\u020F": "\u002E",
    "\u0210": "\u002E", "\u0211": "\u002E", "\u0212": "\u002E", "\u0213": "\u002E", "\u0214": "\u002E", "\u0215": "\u002E", "\u0216": "\u002E", "\u0217": "\u002E",
    "\u0218": "\u0053", "\u0219": "\u0073", "\u021A": "\u0054", "\u021B": "\u0074", "\u021C": "\u002E", "\u021D": "\u002E", "\u021E": "\u002E", "\u021F": "\u002E",
    "\u0220": "\u002E", "\u0221": "\u002E", "\u0222": "\u002E", "\u0223": "\u002E", "\u0224": "\u002E", "\u0225": "\u002E", "\u0226": "\u002E", "\u0227": "\u002E",
    "\u0228": "\u002E", "\u0229": "\u002E", "\u022A": "\u002E", "\u022B": "\u002E", "\u022C": "\u002E", "\u022D": "\u002E", "\u022E": "\u002E", "\u022F": "\u002E",
    "\u0230": "\u002E", "\u0231": "\u002E", "\u0232": "\u002E", "\u0233": "\u002E", "\u0234": "\u002E", "\u0235": "\u002E", "\u0236": "\u002E", "\u0237": "\u002E",
    "\u0238": "\u002E", "\u0239": "\u002E", "\u023A": "\u002E", "\u023B": "\u002E", "\u023C": "\u002E", "\u023D": "\u002E", "\u023E": "\u002E", "\u023F": "\u002E",
    "\u0240": "\u002E", "\u0241": "\u002E", "\u0242": "\u002E", "\u0243": "\u002E", "\u0244": "\u002E", "\u0245": "\u002E", "\u0246": "\u002E", "\u0247": "\u002E",
    "\u0248": "\u002E", "\u0249": "\u002E", "\u024A": "\u002E", "\u024B": "\u002E", "\u024C": "\u002E", "\u024D": "\u002E", "\u024E": "\u002E", "\u024F": "\u002E",
    "\u0250": "\u002E", "\u0251": "\u002E", "\u0252": "\u002E", "\u0253": "\u002E", "\u0254": "\u002E", "\u0255": "\u002E", "\u0256": "\u002E", "\u0257": "\u002E",
    "\u0258": "\u002E", "\u0259": "\u002E", "\u025A": "\u002E", "\u025B": "\u002E", "\u025C": "\u002E", "\u025D": "\u002E", "\u025E": "\u002E", "\u025F": "\u002E",
    "\u0260": "\u002E", "\u0261": "\u002E", "\u0262": "\u002E", "\u0263": "\u002E", "\u0264": "\u002E", "\u0265": "\u002E", "\u0266": "\u002E", "\u0267": "\u002E",
    "\u0268": "\u002E", "\u0269": "\u002E", "\u026A": "\u002E", "\u026B": "\u002E", "\u026C": "\u002E", "\u026D": "\u002E", "\u026E": "\u002E", "\u026F": "\u002E",
    "\u0270": "\u002E", "\u0271": "\u002E", "\u0272": "\u002E", "\u0273": "\u002E", "\u0274": "\u002E", "\u0275": "\u002E", "\u0276": "\u002E", "\u0277": "\u002E",
    "\u0278": "\u002E", "\u0279": "\u002E", "\u027A": "\u002E", "\u027B": "\u002E", "\u027C": "\u002E", "\u027D": "\u002E", "\u027E": "\u002E", "\u027F": "\u002E",
    "\u0280": "\u002E", "\u0281": "\u002E", "\u0282": "\u002E", "\u0283": "\u002E", "\u0284": "\u002E", "\u0285": "\u002E", "\u0286": "\u002E", "\u0287": "\u002E",
    "\u0288": "\u002E", "\u0289": "\u002E", "\u028A": "\u002E", "\u028B": "\u002E", "\u028C": "\u002E", "\u028D": "\u002E", "\u028E": "\u002E", "\u028F": "\u002E",
    "\u0290": "\u002E", "\u0291": "\u002E", "\u0292": "\u002E", "\u0293": "\u002E", "\u0294": "\u002E", "\u0295": "\u002E", "\u0296": "\u002E", "\u0297": "\u002E",
    "\u0298": "\u002E", "\u0299": "\u002E", "\u029A": "\u002E", "\u029B": "\u002E", "\u029C": "\u002E", "\u029D": "\u002E", "\u029E": "\u002E", "\u029F": "\u002E",
    "\u02A0": "\u002E", "\u02A1": "\u002E", "\u02A2": "\u002E", "\u02A3": "\u002E", "\u02A4": "\u002E", "\u02A5": "\u002E", "\u02A6": "\u002E", "\u02A7": "\u002E",
    "\u02A8": "\u002E", "\u02A9": "\u002E", "\u02AA": "\u002E", "\u02AB": "\u002E", "\u02AC": "\u002E", "\u02AD": "\u002E", "\u02AE": "\u002E", "\u02AF": "\u002E",
    "\u02B0": "\u002E", "\u02B1": "\u002E", "\u02B2": "\u002E", "\u02B3": "\u002E", "\u02B4": "\u002E", "\u02B5": "\u002E", "\u02B6": "\u002E", "\u02B7": "\u002E",
    "\u02B8": "\u002E", "\u02B9": "\u002E", "\u02BA": "\u002E", "\u02BB": "\u002E", "\u02BC": "\u002E", "\u02BD": "\u002E", "\u02BE": "\u002E", "\u02BF": "\u002E",
    "\u02C0": "\u002E", "\u02C1": "\u002E", "\u02C2": "\u002E", "\u02C3": "\u002E", "\u02C4": "\u002E", "\u02C5": "\u002E", "\u02C6": "\u002E", "\u02C7": "\u002E",
    "\u02C8": "\u002E", "\u02C9": "\u002E", "\u02CA": "\u002E", "\u02CB": "\u002E", "\u02CC": "\u002E", "\u02CD": "\u002E", "\u02CE": "\u002E", "\u02CF": "\u002E",
    "\u02D0": "\u002E", "\u02D1": "\u002E", "\u02D2": "\u002E", "\u02D3": "\u002E", "\u02D4": "\u002E", "\u02D5": "\u002E", "\u02D6": "\u002E", "\u02D7": "\u002E",
    "\u02D8": "\u002E", "\u02D9": "\u002E", "\u02DA": "\u002E", "\u02DB": "\u002E", "\u02DC": "\u002E", "\u02DD": "\u002E", "\u02DE": "\u002E", "\u02DF": "\u002E",
    "\u02E0": "\u002E", "\u02E1": "\u002E", "\u02E2": "\u002E", "\u02E3": "\u002E", "\u02E4": "\u002E", "\u02E5": "\u002E", "\u02E6": "\u002E", "\u02E7": "\u002E",
    "\u02E8": "\u002E", "\u02E9": "\u002E", "\u02EA": "\u002E", "\u02EB": "\u002E", "\u02EC": "\u002E", "\u02ED": "\u002E", "\u02EE": "\u002E", "\u02EF": "\u002E",
    "\u02F0": "\u002E", "\u02F1": "\u002E", "\u02F2": "\u002E", "\u02F3": "\u002E", "\u02F4": "\u002E", "\u02F5": "\u002E", "\u02F6": "\u002E", "\u02F7": "\u002E",
    "\u02F8": "\u002E", "\u02F9": "\u002E", "\u02FA": "\u002E", "\u02FB": "\u002E", "\u02FC": "\u002E", "\u02FD": "\u002E", "\u02FE": "\u002E", "\u02FF": "\u002E",
    "\u0300": "\u002E", "\u0301": "\u002E", "\u0302": "\u002E", "\u0303": "\u002E", "\u0304": "\u002E", "\u0305": "\u002E", "\u0306": "\u002E", "\u0307": "\u002E",
    "\u0308": "\u002E", "\u0309": "\u002E", "\u030A": "\u002E", "\u030B": "\u002E", "\u030C": "\u002E", "\u030D": "\u002E", "\u030E": "\u002E", "\u030F": "\u002E",
    "\u0310": "\u002E", "\u0311": "\u002E", "\u0312": "\u002E", "\u0313": "\u002E", "\u0314": "\u002E", "\u0315": "\u002E", "\u0316": "\u002E", "\u0317": "\u002E",
    "\u0318": "\u002E", "\u0319": "\u002E", "\u031A": "\u002E", "\u031B": "\u002E", "\u031C": "\u002E", "\u031D": "\u002E", "\u031E": "\u002E", "\u031F": "\u002E",
    "\u0320": "\u002E", "\u0321": "\u002E", "\u0322": "\u002E", "\u0323": "\u002E", "\u0324": "\u002E", "\u0325": "\u002E", "\u0326": "\u002E", "\u0327": "\u002E",
    "\u0328": "\u002E", "\u0329": "\u002E", "\u032A": "\u002E", "\u032B": "\u002E", "\u032C": "\u002E", "\u032D": "\u002E", "\u032E": "\u002E", "\u032F": "\u002E",
    "\u0330": "\u002E", "\u0331": "\u002E", "\u0332": "\u002E", "\u0333": "\u002E", "\u0334": "\u002E", "\u0335": "\u002E", "\u0336": "\u002E", "\u0337": "\u002E",
    "\u0338": "\u002E", "\u0339": "\u002E", "\u033A": "\u002E", "\u033B": "\u002E", "\u033C": "\u002E", "\u033D": "\u002E", "\u033E": "\u002E", "\u033F": "\u002E",
    "\u0340": "\u002E", "\u0341": "\u002E", "\u0342": "\u002E", "\u0343": "\u002E", "\u0344": "\u002E", "\u0345": "\u002E", "\u0346": "\u002E", "\u0347": "\u002E",
    "\u0348": "\u002E", "\u0349": "\u002E", "\u034A": "\u002E", "\u034B": "\u002E", "\u034C": "\u002E", "\u034D": "\u002E", "\u034E": "\u002E", "\u034F": "\u002E",
    "\u0350": "\u002E", "\u0351": "\u002E", "\u0352": "\u002E", "\u0353": "\u002E", "\u0354": "\u002E", "\u0355": "\u002E", "\u0356": "\u002E", "\u0357": "\u002E",
    "\u0358": "\u002E", "\u0359": "\u002E", "\u035A": "\u002E", "\u035B": "\u002E", "\u035C": "\u002E", "\u035D": "\u002E", "\u035E": "\u002E", "\u035F": "\u002E",
    "\u0360": "\u002E", "\u0361": "\u002E", "\u0362": "\u002E", "\u0363": "\u002E", "\u0364": "\u002E", "\u0365": "\u002E", "\u0366": "\u002E", "\u0367": "\u002E",
    "\u0368": "\u002E", "\u0369": "\u002E", "\u036A": "\u002E", "\u036B": "\u002E", "\u036C": "\u002E", "\u036D": "\u002E", "\u036E": "\u002E", "\u036F": "\u002E",
    "\u0370": "\u002E", "\u0371": "\u002E", "\u0372": "\u002E", "\u0373": "\u002E", "\u0374": "\u002E", "\u0375": "\u002E", "\u0376": "\u002E", "\u0377": "\u002E",
    "\u0378": "\u002E", "\u0379": "\u002E", "\u037A": "\u002E", "\u037B": "\u002E", "\u037C": "\u002E", "\u037D": "\u002E", "\u037E": "\u002E", "\u037F": "\u002E",
    "\u0380": "\u002E", "\u0381": "\u002E", "\u0382": "\u002E", "\u0383": "\u002E", "\u0384": "\u002E", "\u0385": "\u002E", "\u0386": "\u0041", "\u0387": "\u002E",
    "\u0388": "\u0045", "\u0389": "\u0049", "\u038A": "\u0049", "\u038B": "\u002E", "\u038C": "\u004F", "\u038D": "\u002E", "\u038E": "\u0059", "\u038F": "\u004F",
    "\u0390": "\u0069", "\u0391": "\u0041", "\u0392": "\u0056", "\u0393": "\u0047", "\u0394": "\u0044", "\u0395": "\u0045", "\u0396": "\u005A", "\u0397": "\u0049",
    "\u0398": "\u0054\u0048", "\u0399": "\u0049", "\u039A": "\u004B", "\u039B": "\u004C", "\u039C": "\u004D", "\u039D": "\u004E", "\u039E": "\u0058", "\u039F": "\u004F",
    "\u03A0": "\u0050", "\u03A1": "\u0052", "\u03A2": "\u002E", "\u03A3": "\u0053", "\u03A4": "\u0054", "\u03A5": "\u0059", "\u03A6": "\u0046", "\u03A7": "\u0043\u0048",
    "\u03A8": "\u0050\u0053", "\u03A9": "\u004F", "\u03AA": "\u0049", "\u03AB": "\u0059", "\u03AC": "\u0061", "\u03AD": "\u0065", "\u03AE": "\u0069", "\u03AF": "\u0069",
    "\u03B0": "\u0079", "\u03B1": "\u0061", "\u03B2": "\u0076", "\u03B3": "\u0067", "\u03B4": "\u0064", "\u03B5": "\u0065", "\u03B6": "\u007A", "\u03B7": "\u0069",
    "\u03B8": "\u0074\u0068", "\u03B9": "\u0069", "\u03BA": "\u006B", "\u03BB": "\u006C", "\u03BC": "\u006D", "\u03BD": "\u006E", "\u03BE": "\u0078", "\u03BF": "\u006F",
    "\u03C0": "\u0070", "\u03C1": "\u0072", "\u03C2": "\u0073", "\u03C3": "\u0073", "\u03C4": "\u0074", "\u03C5": "\u0079", "\u03C6": "\u0066", "\u03C7": "\u0063\u0068",
    "\u03C8": "\u0070\u0073", "\u03C9": "\u006F", "\u03CA": "\u0069", "\u03CB": "\u0079", "\u03CC": "\u006F", "\u03CD": "\u0079", "\u03CE": "\u006F", "\u03CF": "\u002E",
    "\u03D0": "\u002E", "\u03D1": "\u002E", "\u03D2": "\u002E", "\u03D3": "\u002E", "\u03D4": "\u002E", "\u03D5": "\u002E", "\u03D6": "\u002E", "\u03D7": "\u002E",
    "\u03D8": "\u002E", "\u03D9": "\u002E", "\u03DA": "\u002E", "\u03DB": "\u002E", "\u03DC": "\u002E", "\u03DD": "\u002E", "\u03DE": "\u002E", "\u03DF": "\u002E",
    "\u03E0": "\u002E", "\u03E1": "\u002E", "\u03E2": "\u002E", "\u03E3": "\u002E", "\u03E4": "\u002E", "\u03E5": "\u002E", "\u03E6": "\u002E", "\u03E7": "\u002E",
    "\u03E8": "\u002E", "\u03E9": "\u002E", "\u03EA": "\u002E", "\u03EB": "\u002E", "\u03EC": "\u002E", "\u03ED": "\u002E", "\u03EE": "\u002E", "\u03EF": "\u002E",
    "\u03F0": "\u002E", "\u03F1": "\u002E", "\u03F2": "\u002E", "\u03F3": "\u002E", "\u03F4": "\u002E", "\u03F5": "\u002E", "\u03F6": "\u002E", "\u03F7": "\u002E",
    "\u03F8": "\u002E", "\u03F9": "\u002E", "\u03FA": "\u002E", "\u03FB": "\u002E", "\u03FC": "\u002E", "\u03FD": "\u002E", "\u03FE": "\u002E", "\u03FF": "\u002E",
    "\u0400": "\u002E", "\u0401": "\u002E", "\u0402": "\u002E", "\u0403": "\u002E", "\u0404": "\u002E", "\u0405": "\u002E", "\u0406": "\u002E", "\u0407": "\u002E",
    "\u0408": "\u002E", "\u0409": "\u002E", "\u040A": "\u002E", "\u040B": "\u002E", "\u040C": "\u002E", "\u040D": "\u002E", "\u040E": "\u002E", "\u040F": "\u002E",
    "\u0410": "\u0041", "\u0411": "\u0042", "\u0412": "\u0056", "\u0413": "\u0047", "\u0414": "\u0044", "\u0415": "\u0045", "\u0416": "\u005A\u0048", "\u0417": "\u005A",
    "\u0418": "\u0049", "\u0419": "\u0059", "\u041A": "\u004B", "\u041B": "\u004C", "\u041C": "\u004D", "\u041D": "\u004E", "\u041E": "\u004F", "\u041F": "\u0050",
    "\u0420": "\u0052", "\u0421": "\u0053", "\u0422": "\u0054", "\u0423": "\u0055", "\u0424": "\u0046", "\u0425": "\u0048", "\u0426": "\u0054\u0053",
    "\u0427": "\u0043\u0048", "\u0428": "\u0053\u0048", "\u0429": "\u0053\u0048\u0054", "\u042A": "\u0041", "\u042B": "\u002E", "\u042C": "\u0059", "\u042D": "\u002E",
    "\u042E": "\u0059\u0055", "\u042F": "\u0059\u0041", "\u0430": "\u0061", "\u0431": "\u0062", "\u0432": "\u0076", "\u0433": "\u0067", "\u0434": "\u0064",
    "\u0435": "\u0065", "\u0436": "\u007A\u0068", "\u0437": "\u007A", "\u0438": "\u0069", "\u0439": "\u0079", "\u043A": "\u006B", "\u043B": "\u006C", "\u043C": "\u006D",
    "\u043D": "\u006E", "\u043E": "\u006F", "\u043F": "\u0070", "\u0440": "\u0072", "\u0441": "\u0073", "\u0442": "\u0074", "\u0443": "\u0075", "\u0444": "\u0066",
    "\u0445": "\u0068", "\u0446": "\u0074\u0073", "\u0447": "\u0063\u0068", "\u0448": "\u0073\u0068", "\u0449": "\u0073\u0068\u0074", "\u044A": "\u0061",
    "\u044B": "\u002E", "\u044C": "\u0079", "\u044D": "\u002E", "\u044E": "\u0079\u0075", "\u044F": "\u0079\u0061", "\u0450": "\u002E", "\u0451": "\u002E",
    "\u0452": "\u002E", "\u0453": "\u002E", "\u0454": "\u002E", "\u0455": "\u002E", "\u0456": "\u002E", "\u0457": "\u002E", "\u0458": "\u002E", "\u0459": "\u002E",
    "\u045A": "\u002E", "\u045B": "\u002E", "\u045C": "\u002E", "\u045D": "\u002E",
}
