# -*- coding: utf-8 -*-

from odoo import models, fields, api
from dateutil.relativedelta import relativedelta


class SaleSubscription(models.Model):
    _inherit = "sale.subscription"
    
    contract_name = fields.Char("Nom de contrat")
    contract_number = fields.Char("N° de contrat")
    amount_monthly_ef = fields.Monetary("Montant abonnement mensuel")
    date_sign_ef = fields.Date("Date de signature")
    date_start_ef = fields.Date("Date de début")
    during_contract = fields.Selection([
        ('1', '1 an'),
        ('2', '2 ans'),
        ('3', '3 ans'),
        ('4', '4 ans'),
        ('5', '5 ans'),
        ('6', '6 ans')],string="Durée du contrat")
    date_end_ef = fields.Date("Date de fin théorique", compute='_compute_end_date')
    amount_monthly_ap = fields.Monetary("Montant AP mensuel")
    total_amount_monthly = fields.Monetary("Montant mensuel total")
    periodicity_ef = fields.Selection([
        ('1', 'mensuel'),
        ('2', 'trimestriel'),
        ('3', 'semestriel'),
        ('4', 'annuel')],string="Périodicité")
    periodicity_ap = fields.Selection([
        ('1', 'mensuel'),
        ('2', 'trimestriel'),
        ('3', 'semestriel'),
        ('4', 'annuel')],string="Périodicité")
    financial_partner_id = fields.Many2one('res.partner', string="Etablissement financier")
    total_amount_financed = fields.Monetary("Montant total financé")
    
    @api.depends('date_start_ef', 'during_contract')
    def _compute_end_date(self):
        for sub in self:
            sub.date_end_ef = False
            if sub.date_start_ef and sub.during_contract:
                sub.date_end_ef = fields.Date.to_string(fields.Date.from_string(sub.date_start_ef) + relativedelta(years=int(sub.during_contract)))
            
    def _prepare_invoice_data(self):
        res = super(SaleSubscription, self)._prepare_invoice_data()
        if self.description:
            if self.env['ir.config_parameter'].sudo().get_param('account.use_invoice_terms') and self.company_id.invoice_terms:
                res['narration'] += '\n' + self.company_id.invoice_terms
        return res