# -*- coding: utf-8 -*-

from odoo import models, fields, api, _

class SaleOrder(models.Model):
    _inherit = 'sale.order'
    
    def action_quotation_send(self):
        """ Render the delivery report in pdf and attach it to the picking in `self`. """
        self.ensure_one()
        report = self.env.ref('sale.action_report_saleorder')._render_qweb_pdf(self.id)
        filename = "%s_sent" % self.name
        message = _('Order sent')
        self.message_post(
            attachments=[('%s.pdf' % filename, report[0])],
            body=message,
        )
        
        return super(SaleOrder,self).action_quotation_send()
        
        
    def action_confirm(self):
        res = super(SaleOrder, self).action_confirm()
        for so in self.filtered(lambda l: not l.analytic_account_id):           
            analytic_account_id = self.env['account.analytic.account'].create({
                'name': so.name,
                'partner_id': so.partner_id.id,                
            })
            so.write({
                'analytic_account_id': analytic_account_id.id
            })        
        return res
        
    def _prepare_subscription_data(self, template):
        values = super(SaleOrder, self)._prepare_subscription_data(template)

        default_stage = self.env.ref('access_protection.sale_subscription_stage_to_start')
        if default_stage:
            values['stage_id'] = default_stage.id

        return values
        
        
class SaleOrderLine(models.Model):
    _inherit = 'sale.order.line'
    
    product_supplier_id = fields.Many2one('product.supplierinfo', string='Supplier Product')
    
    
    @api.onchange('product_supplier_id')
    def product_supplier_id_change(self):
        if not self.product_supplier_id:
            return

        product_template = self.product_supplier_id.product_tmpl_id
        product_product = self.product_supplier_id.product_id
        if not product_product and product_template.product_variant_id:
            product_product = product_template.product_variant_id
        if not product_product and product_template.product_variant_ids:
            product_product = product_template.product_variant_ids[0]
            
        self.update({'product_id': product_product.id, 'product_template_id': product_template.id})
        if product_product:
            self.product_id_change()