# -*- coding: utf-8 -*-

from odoo import models, fields, api
import logging
_logger = logging.getLogger(__name__)


class ResPartner(models.Model):
    _inherit = 'res.partner'
    
    ap_contact_category = fields.Selection([('customer','Client'), ('supplier','Fournisseur'), 
        ('employee', 'Employé'), ('prospect', 'Prospect')], string="Catégorie de contact")
    ap_cont_consignes = fields.Html("Consignes")
    ap_cust_payeur = fields.Many2one('res.partner', string="Payeur")
    ap_id_contact = fields.Char("Identifiant")


    @api.model
    def create(self, vals):
        if 'ap_contact_category' in vals and vals['ap_contact_category'] == 'customer':
            vals['customer_rank'] = 1
            vals['ap_id_contact'] = self.env['ir.sequence'].next_by_code('customer_code')
    
        return super(ResPartner, self).create(vals)        
    
    def write(self, vals):
        if 'ap_contact_category' in vals and vals['ap_contact_category'] == 'customer':
            vals['customer_rank'] = 1

        return super(ResPartner, self).write(vals)        
    
    @api.model
    def _install_access_protection(self):        
        # Find records with datas studio
        records = self.search(['|','|','|',("x_studio_categorie_de_contact", "!=", False), ("x_studio_cont_consignes", "!=", False), 
            ("x_studio_cust_payeur", "!=", False), ("x_studio_id_contact", "!=", False),  ])

        # copy datas in new fields
        for record in records:
            if record.x_studio_categorie_de_contact == 'Client':
                record.ap_contact_category = 'customer'
            if record.x_studio_categorie_de_contact == 'Fournisseur':
                record.ap_contact_category = 'supplier'
            if record.x_studio_categorie_de_contact == 'Employé':
                record.ap_contact_category = 'employee'
            if record.x_studio_categorie_de_contact == 'Prospect':
                record.ap_contact_category = 'prospect'
            
            record.ap_cont_consignes = record.x_studio_cont_consignes
            record.ap_cust_payeur = record.x_studio_cust_payeur
            record.ap_id_contact = record.x_studio_id_contact
                
                
        _logger.info("%d partners updated installing module.", len(records))